//AIM:Computation of N-Point DFT using DIF method.
//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
// We will compute the DFT of the sequence x(n)={1,1,1,1,1,1,1,1,0,0,0,0,0,0,0,0}
//using DIF(Split radix) method for N=16(4*4)
//For understanding,let us write the considered input data as
//x(0)=1;x(1)=1,x(2)=1,x(3)=1,x(4)=1,x(5)=1,x(6)=1,x(7)=1,x(8)=0,x(9)=0,x(10)=0,x(11)=0,x(12)=0,x(13)=0,x(14)=0,x(15)=0;
x0=1;//DIF-FFT,so arranging the input in natural order
x1=1;//DIF-FFT,so arranging the input in natural order
x2=1;//DIF-FFT,so arranging the input in natural order
x3=1;//DIF-FFT,so arranging the input in natural order
x4=1;//DIF-FFT,so arranging the input in natural order
x5=1;//DIF-FFT,so arranging the input in natural order
x6=1;//DIF-FFT,so arranging the input in natural order
x7=1;//DIF-FFT,so arranging the input in natural order
x8=0;//DIF-FFT,so arranging the input in natural order
x9=0;//DIF-FFT,so arranging the input in natural order
x10=0;//DIF-FFT,so arranging the input in natural order
x11=0;//DIF-FFT,so arranging the input in natural order
x12=0;//DIF-FFT,so arranging the input in natural order
x13=0;//DIF-FFT,so arranging the input in natural order
x14=0;//DIF-FFT,so arranging the input in natural order
x15=0;//DIF-FFT,so arranging the input in natural order

//Computing the necessary twiddle factors
W0=cos((2*%pi/16)*0)-(sqrt(-1))*sin((2*%pi/16)*0)
disp(W0,'W0=')
W1=cos((2*%pi/16)*1)-(sqrt(-1))*sin((2*%pi/16)*1)
disp(W1,'W1=')
W2=cos((2*%pi/16)*2)-(sqrt(-1))*sin((2*%pi/16)*2)
disp(W2,'W2=')
W3=cos((2*%pi/16)*3)-(sqrt(-1))*sin((2*%pi/16)*3)
disp(W3,'W3=')
W4=cos((2*%pi/16)*4)-(sqrt(-1))*sin((2*%pi/16)*4)
disp(W4,'W4=')
W5=cos((2*%pi/16)*5)-(sqrt(-1))*sin((2*%pi/16)*5)
disp(W5,'W5=')
W6=cos((2*%pi/16)*6)-(sqrt(-1))*sin((2*%pi/16)*6)
disp(W6,'W6=')
W7=cos((2*%pi/16)*7)-(sqrt(-1))*sin((2*%pi/16)*7)
disp(W7,'W7=')
W8=cos((2*%pi/16)*8)-(sqrt(-1))*sin((2*%pi/16)*8)
disp(W8,'W8=')
W9=cos((2*%pi/16)*9)-(sqrt(-1))*sin((2*%pi/16)*9)
disp(W9,'W9=')
W10=cos((2*%pi/16)*10)-(sqrt(-1))*sin((2*%pi/16)*10)
disp(W10,'W10=')
W11=cos((2*%pi/16)*11)-(sqrt(-1))*sin((2*%pi/16)*11)
disp(W11,'W11=')
W12=cos((2*%pi/16)*12)-(sqrt(-1))*sin((2*%pi/16)*12)
disp(W12,'W12=')
W13=cos((2*%pi/16)*13)-(sqrt(-1))*sin((2*%pi/16)*13)
disp(W13,'W13=')
W14=cos((2*%pi/16)*14)-(sqrt(-1))*sin((2*%pi/16)*14)
disp(W14,'W14=')
W15=cos((2*%pi/16)*15)-(sqrt(-1))*sin((2*%pi/16)*15)
disp(W15,'W15=')

x0a=x0+x8;
x1b=x1+x9;
x2c=x2+x10;
x3d=x3+x11;
x4e=x4+x12;
x5f=x5+x13;
x6g=x6+x14;
x7h=x7+x15;
x8i=x0+(-1)*x8;
x9j=(x1+(-1)*x9)*W1;
x10k=(x2+(-1)*x10)*W2;
x11l=(x3+(-1)*x11)*W3;
x12m=(x4+(-1)*x12)*W4;
x13n=(x5+(-1)*x13)*W5;
x14o=(x6+(-1)*x14)*W6;
x15p=(x7+(-1)*x15)*W7;

x0aa=x0a+x4e;
x1bb=x1b+x5f;
x2cc=x2c+x6g;
x3dd=x3d+x7h;
x4ee=x0a+(-1)*x4e;
x5ff=(x1b+(-1)*x5f)*W2;
x6gg=(x2c+(-1)*x6g)*W4;
x7hh=(x3d+(-1)*x7h)*W6;
x8ii=x8i+x12m;
x9jj=x9j+x13n;
x10kk=x10k+x14o;
x11ll=x11l+x15p;
x12mm=x8i+(-1)*x12m;
x13nn=(x9j+(-1)*x13n)*W2;
x14oo=(x10k+(-1)*x14o)*W4;
x15pp=(x11l+(-1)*x15p)*W6;

x0aaa=x0aa+x2cc;
x1bbb=x1bb+x3dd;
x2ccc=x0aa+(-1)*x2cc;
x3ddd=(x1bb+(-1)*x3dd)*W4;
x4eee=x4ee+x6gg;
x5fff=x5ff+x7hh;
x6ggg=x4ee+(-1)*x6gg;
x7hhh=(x5ff+(-1)*x7hh)*W4;
x8iii=x8ii+x10kk;
x9jjj=x9jj+x11ll;
x10kkk=x8ii+(-1)*x10kk;
x11lll=(x9jj+(-1)*x11ll)*W4;
x12mmm=x12mm+x14oo;
x13nnn=x13nn+x15pp;
x14ooo=x12mm+(-1)*x14oo;
x15ppp=(x13nn+(-1)*x15pp)*W4;

//Final output
X0=x0aaa+x1bbb;
X8=x0aaa+(-1)*x1bbb;
X4=x2ccc+x3ddd;
X12=x2ccc+(-1)*x3ddd;
X2=x4eee+x5fff;
X10=x4eee+(-1)*x5fff;
X6=x6ggg+x7hhh;
X14=x6ggg+(-1)*x7hhh;
X1=x8iii+x9jjj;
X9=x8iii+(-1)*x9jjj;
X5=x10kkk+x11lll;
X13=x10kkk+(-1)*x11lll;
X3=x12mmm+x13nnn;
X11=x12mmm+(-1)*x13nnn;
X7=x14ooo+x15ppp;
X15=x14ooo+(-1)*x15ppp;
disp({,X8,X4,X12,X2,X10,X6,X14,X1,X9,X5,X13,X3,X11,X7,X15,},'The computed values are')
disp({X0,X1,X2,X3,X4,X5,X6,X7,X8,X9,X10,X11,X12,X13,X14,X15},'So,the DFT of x(n) using Decimation-in-Frequency Fast Fourier Transform(DIF-FFT) is X(k)=')

//Expected output:X(k)={8,1.-5.0273395i,0,1-1.4966058i,0,1-0.6681786i,0,1-0.1989124i,0,1+0.1989124i,0,
//1+0.6681786i,0,1+1.4966058i,0,1+5.0273395i} 































